/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcz;

import java.util.ArrayList;
import java.util.List;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchGenericRefHost;
import oracle.sysman.oip.oipc.oipch.OipchHost;
import oracle.sysman.oip.oipc.oipch.OipchIHasKernel;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectVersionFormatException;
import oracle.sysman.oip.oipc.oipch.OipchInverseRangeList;
import oracle.sysman.oip.oipc.oipch.OipchKernelInfo;
import oracle.sysman.oip.oipc.oipch.OipchKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchLinuxVersion;
import oracle.sysman.oip.oipc.oipch.OipchMemory;
import oracle.sysman.oip.oipc.oipch.OipchNumKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchOS;
import oracle.sysman.oip.oipc.oipch.OipchRangeKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchRangeSemantics;
import oracle.sysman.oip.oipc.oipch.OipchSolarisVersion;
import oracle.sysman.oip.oipc.oipch.OipchStrKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchSystem;
import oracle.sysman.oip.oipc.oipch.OipchVerKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchVersion;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;
import oracle.sysman.oip.oipc.oipcz.OipczStep;
import oracle.sysman.oip.oipc.oipcz.OipczStepChecker;
import oracle.sysman.oix.oixd.OixdInvalidDocumentException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OipczKernelChecks {
    private static final String SEPARATOR = ",";

    private OipczKernelChecks() {
    }

    public static OipcrIResult checkParameters(OipcrIRulesEngine oRulesEngine, String sRefFile) throws OixdInvalidDocumentException {
        OipcrIResult oResult;
        block72: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            long sval = 1L;
            if (oRulesEngine != null) {
                try {
                    Node oOSNode;
                    OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
                    OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                    OipchOS oOS = oHost.getOS();
                    OipchStrKernelProperty oGlibc = null;
                    OipchIHasKernel oOSWithKernel = (OipchIHasKernel)((Object)oOS);
                    OipchVersion oVer = oOS.getOSVersion();
                    boolean bIfStepNodes = false;
                    boolean bIfStepsNodes = false;
                    boolean bIfRangeParameter = false;
                    boolean bIfExcludeTag = false;
                    boolean bIfExcludeCheckPassed = false;
                    Node node = oOSNode = oVer == null ? null : oGenRefHost.getOSNode(oVer);
                    if (oOSNode != null) {
                        Node nodewithkernelversion = oGenRefHost.getNode("CERTIFIED_SYSTEMS/OPERATING_SYSTEM");
                        NodeList oNodeFinally = nodewithkernelversion.getChildNodes();
                        int nNodeFinally = oNodeFinally.getLength();
                        NamedNodeMap oNodeFinallyAttribs = null;
                        String sExpectedValKernelVer = null;
                        String sPropNameKernelVer = null;
                        Node oAttribKernel = null;
                        Node oKernelversionNode = null;
                        for (int i1 = 0; i1 < nNodeFinally; ++i1) {
                            oKernelversionNode = oNodeFinally.item(i1);
                            if (oKernelversionNode == null || oKernelversionNode.getNodeType() != 1 || !oKernelversionNode.getNodeName().equalsIgnoreCase("KERNEL_VERSION")) continue;
                            oNodeFinallyAttribs = oKernelversionNode.getAttributes();
                            oAttribKernel = oNodeFinallyAttribs.getNamedItem("VALUE");
                            sExpectedValKernelVer = oAttribKernel.getNodeValue();
                            break;
                        }
                        OipchVerKernelProperty oExpectedPropertyKernelVer = null;
                        sPropNameKernelVer = "VERSION";
                        OipchKernelInfo oActualKernel1 = oOSWithKernel.getKernel();
                        OipchKernelProperty oActualProperty1 = oActualKernel1.getProperty(sPropNameKernelVer);
                        int iPlatID1 = oGenRefHost.getCurrentPlatform();
                        switch (iPlatID1) {
                            case 453: {
                                try {
                                    oExpectedPropertyKernelVer = new OipchVerKernelProperty(sPropNameKernelVer, new OipchSolarisVersion(sExpectedValKernelVer));
                                }
                                catch (OipchIncorrectVersionFormatException oIvfe) {
                                    oExpectedPropertyKernelVer = new OipchVerKernelProperty(sPropNameKernelVer, new OipchVersion(sExpectedValKernelVer));
                                }
                                break;
                            }
                            case 46: {
                                try {
                                    if (sPropNameKernelVer == null || sExpectedValKernelVer == null) break;
                                    oExpectedPropertyKernelVer = new OipchVerKernelProperty(sPropNameKernelVer, new OipchLinuxVersion(sExpectedValKernelVer));
                                }
                                catch (OipchIncorrectVersionFormatException oIvfe) {
                                    if (sPropNameKernelVer == null || sExpectedValKernelVer == null) break;
                                    oExpectedPropertyKernelVer = new OipchVerKernelProperty(sPropNameKernelVer, new OipchVersion(sExpectedValKernelVer));
                                }
                                break;
                            }
                            default: {
                                oExpectedPropertyKernelVer = new OipchVerKernelProperty(sPropNameKernelVer, new OipchVersion(sExpectedValKernelVer));
                            }
                        }
                        Node oKernelNode = oGenRefHost.getNode("KERNEL", oOSNode);
                        if (oKernelNode != null) {
                            NodeList oPropertyNodes = oKernelNode.getChildNodes();
                            if (oPropertyNodes != null) {
                                int nPropertyNodes = oPropertyNodes.getLength();
                                Node oPropertyNode = null;
                                ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                                for (int i = 0; i < nPropertyNodes; ++i) {
                                    Object[] args;
                                    oPropertyNode = oPropertyNodes.item(i);
                                    String sExpectedValue = null;
                                    String sExpectedValueString = null;
                                    Long oLower = null;
                                    Long oUpper = null;
                                    if (oPropertyNode.getNodeType() != 1 || !oPropertyNode.getNodeName().equalsIgnoreCase("PROPERTY")) continue;
                                    NamedNodeMap oNodeAttribs = oPropertyNode.getAttributes();
                                    Node oAttrib = null;
                                    if (oNodeAttribs != null) {
                                        block71: {
                                            bIfStepNodes = oGenRefHost.hasStepNodes(oPropertyNode);
                                            bIfStepsNodes = oGenRefHost.hasStepsNodes(oPropertyNode);
                                            bIfRangeParameter = oGenRefHost.isRangeProperty(oPropertyNode);
                                            bIfExcludeTag = oGenRefHost.hasExcludeNode(oPropertyNode);
                                            if (bIfStepsNodes) {
                                                Node oKernelStepsNode = oGenRefHost.getKernelStepsNode();
                                                NodeList nlSTEP = oPropertyNode.getChildNodes();
                                                int lengthSTEPNodes = nlSTEP.getLength();
                                                Node STEPSNode = nlSTEP.item(1);
                                                NodeList nlSTEP2 = STEPSNode.getChildNodes();
                                                OipczStep oStep = OipczStepChecker.doStepCheck(STEPSNode, oHost);
                                                if (oStep != null) {
                                                    if (oStep.getRetType() == 0) {
                                                        sExpectedValue = oStep.getReturnValue();
                                                    } else if (oStep.getRetType() == 1) {
                                                        String sMultiple = oStep.getReturnValue();
                                                        double dMultiple = -1.0;
                                                        if (sMultiple != null) {
                                                            dMultiple = Double.parseDouble(sMultiple);
                                                            OipchSystem oSystem = oHost.getSystem();
                                                            long longVal = OipczKernelChecks.checkKernelMultParam(dMultiple, oSystem);
                                                            sExpectedValue = "" + longVal + "";
                                                        }
                                                    }
                                                } else {
                                                    sExpectedValue = null;
                                                }
                                            } else if (bIfStepNodes) {
                                                OipczStep oStep = OipczStepChecker.doStepCheck(oPropertyNode, oHost);
                                                if (oStep != null) {
                                                    if (oStep.getRetType() == 0) {
                                                        sExpectedValue = oStep.getReturnValue();
                                                    } else if (oStep.getRetType() == 1) {
                                                        String sMultiple = oStep.getReturnValue();
                                                        double dMultiple = -1.0;
                                                        if (sMultiple != null) {
                                                            dMultiple = Double.parseDouble(sMultiple);
                                                            OipchSystem oSystem = oHost.getSystem();
                                                            long longVal = OipczKernelChecks.checkKernelMultParam(dMultiple, oSystem);
                                                            sExpectedValue = "" + longVal + "";
                                                        }
                                                    }
                                                } else {
                                                    sExpectedValue = null;
                                                }
                                            } else if (bIfRangeParameter) {
                                                try {
                                                    oAttrib = oNodeAttribs.getNamedItem("ATLEAST");
                                                    if (oAttrib != null) {
                                                        oLower = new Long(oAttrib.getNodeValue());
                                                        sExpectedValue = oLower.toString();
                                                    }
                                                    oAttrib = null;
                                                    oAttrib = oNodeAttribs.getNamedItem("ATMOST");
                                                    if (oAttrib == null) break block71;
                                                    oUpper = new Long(oAttrib.getNodeValue());
                                                    if (sExpectedValue == null) {
                                                        sExpectedValue = oUpper.toString();
                                                        break block71;
                                                    }
                                                    if (bIfExcludeTag) {
                                                        sExpectedValue = sExpectedValue + " - " + oUpper.toString();
                                                        oGlibc = new OipchStrKernelProperty(sPropNameKernelVer, sExpectedValue);
                                                        sExpectedValue = OipczKernelChecks.doExcludeCheck(oPropertyNode, oGlibc, sExpectedValue);
                                                        bIfExcludeCheckPassed = OipczKernelChecks.doExcludeCheckTest(oPropertyNode, oGlibc, sExpectedValue);
                                                        break block71;
                                                    }
                                                    sExpectedValue = sExpectedValue + " - " + oUpper.toString();
                                                }
                                                catch (NumberFormatException oNfe) {
                                                    sExpectedValue = null;
                                                }
                                            } else {
                                                oAttrib = oNodeAttribs.getNamedItem("VALUE");
                                                if (oAttrib == null) {
                                                    args = new String[]{"PROPERTY", "VALUE"};
                                                    throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args));
                                                }
                                                sExpectedValue = oAttrib.getNodeValue();
                                            }
                                        }
                                        List oPropNames = OipczKernelChecks.getKernelPropNames(oNodeAttribs);
                                        if (oPropNames == null || oPropNames.isEmpty()) {
                                            Object[] args2 = new String[]{"PROPERTY", "NAME"};
                                            throw new OixdInvalidDocumentException("OUI-11101", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11101", (Object[])args2));
                                        }
                                        String[] asProps = new String[oPropNames.size()];
                                        asProps = oPropNames.toArray(asProps);
                                        if (sExpectedValue == null) {
                                            Object[] args3 = new String[]{OiixFunctionOps.implodeList((String[])asProps, (String)SEPARATOR)};
                                            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-11107", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11107", (Object[])args3)));
                                            return oResult;
                                        }
                                        OipchKernelInfo oActualKernel = oOSWithKernel.getKernel();
                                        String sActualValue = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OIPCZ006");
                                        OipcrIResult oRes = null;
                                        if (oActualKernel != null) {
                                            boolean bPropFound = false;
                                            for (int j = 0; !bPropFound && j < oPropNames.size(); ++j) {
                                                String sPropName = asProps[j];
                                                OipchKernelProperty oActualProperty = oActualKernel.getProperty(sPropName);
                                                Object[] expargs = new String[]{sPropName, sExpectedValue};
                                                sExpectedValueString = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OIPCZ003", (Object[])expargs);
                                                if (oActualProperty == null) continue;
                                                bPropFound = true;
                                                OipchKernelProperty oExpectedProperty = null;
                                                if (sPropName.equals("VERSION")) {
                                                    int iPlatID = oGenRefHost.getCurrentPlatform();
                                                    switch (iPlatID) {
                                                        case 453: {
                                                            try {
                                                                oExpectedProperty = new OipchVerKernelProperty(sPropName, new OipchSolarisVersion(sExpectedValue));
                                                            }
                                                            catch (OipchIncorrectVersionFormatException oIvfe) {
                                                                oExpectedProperty = new OipchVerKernelProperty(sPropName, new OipchVersion(sExpectedValue));
                                                            }
                                                            break;
                                                        }
                                                        case 46: 
                                                        case 211: {
                                                            try {
                                                                oExpectedProperty = new OipchVerKernelProperty(sPropName, new OipchLinuxVersion(sExpectedValue));
                                                            }
                                                            catch (OipchIncorrectVersionFormatException oIvfe) {
                                                                oExpectedProperty = new OipchVerKernelProperty(sPropName, new OipchVersion(sExpectedValue));
                                                            }
                                                            break;
                                                        }
                                                        default: {
                                                            oExpectedProperty = new OipchVerKernelProperty(sPropName, new OipchVersion(sExpectedValue));
                                                            break;
                                                        }
                                                    }
                                                } else if (bIfRangeParameter) {
                                                    oExpectedProperty = new OipchRangeKernelProperty(sPropName, oLower, oUpper);
                                                } else {
                                                    try {
                                                        oExpectedProperty = new OipchNumKernelProperty(sPropName, new Long(sExpectedValue));
                                                    }
                                                    catch (NumberFormatException e) {
                                                        String sHex = "0x";
                                                        if (sExpectedValue.toLowerCase().startsWith(sHex)) {
                                                            try {
                                                                long lVal = Long.parseLong(sExpectedValue.substring(sHex.length(), 16));
                                                                oExpectedProperty = new OipchNumKernelProperty(sPropName, new Long(lVal));
                                                            }
                                                            catch (NumberFormatException e2) {
                                                                oExpectedProperty = new OipchStrKernelProperty(sPropName, sExpectedValue);
                                                            }
                                                        }
                                                        oExpectedProperty = new OipchStrKernelProperty(sPropName, sExpectedValue);
                                                    }
                                                }
                                                Object[] actargs = new String[]{sPropName, oActualProperty.getValue().toString()};
                                                sActualValue = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OIPCZ003", (Object[])actargs);
                                                int iCompare = oActualProperty.compare(oExpectedProperty);
                                                oRes = iCompare == 1 || iCompare == 4 ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                                            }
                                            if (!bPropFound) {
                                                oRes = OipcrResult.FAILED_RESULT;
                                            }
                                            if (bIfExcludeTag) {
                                                if (oRes == OipcrResult.FAILED_RESULT) {
                                                    oResDetails.add(new OipcrResultDetails((Object)sActualValue, sExpectedValueString, oRes));
                                                    continue;
                                                }
                                                if (!bIfExcludeCheckPassed) {
                                                    oRes = OipcrResult.FAILED_RESULT;
                                                    oResDetails.add(new OipcrResultDetails((Object)sActualValue, sExpectedValueString, oRes));
                                                    continue;
                                                }
                                                oRes = OipcrResult.PASSED_RESULT;
                                                oResDetails.add(new OipcrResultDetails((Object)sActualValue, sExpectedValueString, oRes));
                                                continue;
                                            }
                                            oResDetails.add(new OipcrResultDetails((Object)sActualValue, sExpectedValueString, oRes));
                                            continue;
                                        }
                                        throw new OipcrExecuteRuleException("OUI-18002", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OUI-18002"));
                                    }
                                    args = new String[]{"PROPERTY"};
                                    throw new OixdInvalidDocumentException("OUI-11202", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11202", (Object[])args));
                                }
                                oResult = new OipcrResult(oResDetails);
                                break block72;
                            }
                            oResult = OipcrResult.NOT_EXECUTED_RESULT;
                            break block72;
                        }
                        oResult = OipcrResult.NOT_EXECUTED_RESULT;
                        break block72;
                    }
                    Object[] args = new String[]{oOS == null ? OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OIPCZ004") : oOS.getOSName(), oVer == null ? OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OIPCZ005") : oVer.getDisplayName()};
                    oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-18001", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OUI-18001", (Object[])args)));
                }
                catch (OipcrExecuteRuleException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckNoReferenceSpecifiedException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    private static List getKernelPropNames(NamedNodeMap oNodeAttribs) {
        ArrayList<String> oPropNames = new ArrayList<String>();
        for (int i = 0; i < oNodeAttribs.getLength(); ++i) {
            Node oAttrib = oNodeAttribs.item(i);
            if (oAttrib.getNodeType() != 2 || oAttrib.getNodeName().indexOf("NAME") == -1) continue;
            oPropNames.add(oAttrib.getNodeValue());
        }
        return oPropNames;
    }

    private static long checkKernelMultParam(double dMultiple, OipchSystem oSystem) {
        Double returnVal = new Double(0.0);
        long returnValFinal = 0L;
        if (oSystem != null) {
            OipchMemory oSwap = oSystem.getSwapSpace();
            OipchMemory oPhyMem = oSystem.getPhysicalMemory();
            long lSwap = oSwap.getSize();
            OipchMemory oMultPhyMem = new OipchMemory();
            oMultPhyMem.setSize((long)(dMultiple * (double)oPhyMem.getSize()), oPhyMem.getUnit());
            if (oPhyMem.getUnit() == 0) {
                double etc = dMultiple * (double)oPhyMem.getSize() * 1024.0;
                returnVal = new Double(etc);
            } else if (oPhyMem.getUnit() == 1) {
                double etc1 = dMultiple * (double)oPhyMem.getSize() * 1024.0 * 1024.0;
                returnVal = new Double(etc1);
            } else {
                returnVal = new Double(0.0);
            }
        }
        returnValFinal = returnVal.longValue();
        return returnValFinal;
    }

    private static String doExcludeCheck(Node oKernelNode, OipchKernelProperty oGlibc, String sExpectedKernel) throws OixdInvalidDocumentException {
        boolean bExclude = true;
        StringBuffer sExpectedKernelBuf = new StringBuffer(sExpectedKernel);
        sExpectedKernelBuf.append(" ");
        NodeList oExcludeNodes = oKernelNode.getChildNodes();
        String intermediatestring = sExpectedKernel;
        String sPropNameKernel = "VERSION";
        OipchStrKernelProperty oRefGlibc = new OipchStrKernelProperty(sPropNameKernel, sExpectedKernel);
        if (oExcludeNodes != null) {
            int nExcludeNodes = oExcludeNodes.getLength();
            NamedNodeMap oExcludeNodeAttribs = null;
            for (int i = 0; i < nExcludeNodes && bExclude; ++i) {
                Node oExcludeNode = oExcludeNodes.item(i);
                if (oExcludeNode.getNodeType() != 1 || !oExcludeNode.getNodeName().equalsIgnoreCase("EXCLUDE") || (oExcludeNodeAttribs = oExcludeNode.getAttributes()) == null) continue;
                OipchInverseRangeList oInvRangeList = new OipchInverseRangeList(oExcludeNodeAttribs);
                sExpectedKernelBuf.append(oInvRangeList.toString());
                bExclude = OipchRangeSemantics.doComparisons(oInvRangeList.getRangeList(), oRefGlibc, oGlibc);
                oInvRangeList = null;
            }
        }
        return sExpectedKernelBuf.toString();
    }

    private static boolean doExcludeCheckTest(Node oKernelNode, OipchKernelProperty oGlibc, String sExpectedValue) throws OixdInvalidDocumentException {
        boolean bExclude = true;
        NodeList oExcludeNodes = oKernelNode.getChildNodes();
        String sPropNameKernel = "VERSION";
        OipchStrKernelProperty oRefGlibc = new OipchStrKernelProperty(sPropNameKernel, sExpectedValue);
        if (oExcludeNodes != null) {
            int nExcludeNodes = oExcludeNodes.getLength();
            NamedNodeMap oExcludeNodeAttribs = null;
            for (int i = 0; i < nExcludeNodes && bExclude; ++i) {
                Node oExcludeNode = oExcludeNodes.item(i);
                if (oExcludeNode.getNodeType() != 1 || !oExcludeNode.getNodeName().equalsIgnoreCase("EXCLUDE") || (oExcludeNodeAttribs = oExcludeNode.getAttributes()) == null) continue;
                OipchInverseRangeList oInvRangeList = new OipchInverseRangeList(oExcludeNodeAttribs);
                bExclude = OipchRangeSemantics.doComparisons(oInvRangeList.getRangeList(), oRefGlibc, oGlibc);
                oInvRangeList = null;
            }
        }
        return bExclude;
    }
}

